<?php

global $reviewsite_toprating;

class ReviewSiteTopRating extends ReviewSiteApp
{
	public $table		= "top_rating";
	public $structure;
	public $ratings;
	public $data;
	public $status;
	public $edit			= false;
	public $rating_option	= array(
								'5'	=> '5 ( Best )',
								'4'	=> '4 ( Very Good )',
								'3' => '3 ( Good )',
								'2' => '2 ( Not Good Enough ) ',
								'1' => '1 ( Bad )'
								
							  );
	public $hide			= array(
								'true'	=> 'Yes',
								'false'	=> 'No',
							  );
	
	/* init */
	function init()
	{
		global $wpdb;
	
		$this->structure	= "`id` INT NOT NULL AUTO_INCREMENT PRIMARY KEY ,".
							  "`name` VARCHAR( 255 ) NOT NULL ,".
							  "`rating` TINYINT NOT NULL ,".
							  "`visit_link` TEXT NOT NULL ,".
							  "`review_link` TEXT NOT NULL ,".
							  "`hide` ENUM( 'true', 'false' ) NOT NULL ";
	
		if($this->checkTable($this->table) == 'false') :
			$this->createTable($this->table,$this->structure);
			
			$query	= "INSERT INTO `".$wpdb->prefix.$this->table."` ".
					  "VALUE ('1','','','','','true'), ".
					  "('2','','','','','true'),".
					  "('3','','','','','true'),".
					  "('4','','','','','true'),".
					  "('5','','','','','true')";
					  
			$wpdb->query($query);
		endif;
		
		add_action("admin_menu",array(&$this,"createMenu"));
	}
	
	// create menu
	function createMenu()
	{
		add_submenu_page( 'reviewSite', 'ReviewSite Service &bull; Top Rating', 'Top Rating', 'manage_categories', 'reviewSite-top-rating', array(&$this,"view"));
	}
	
	/*==================================================================================*/
	/*=========================			  CONTROLLER		   =========================*/
	/*==================================================================================*/
	
	// processing Input
	function processingInput()
	{
		if(isset($_POST['rating']) && isset($_POST['_wpnonce'])) :
			check_admin_referer('reviewSite-update-top-rating');
			$this->data	= $_POST['rating'];
			$this->updateData();
			
		elseif(isset($_REQUEST['action']) && $_REQUEST['action'] == 'edit' && $_REQUEST['page'] == 'reviewSite-top-rating') :
		
			$this->edit	= true;
			$this->getData($_REQUEST['ID']);
			
		elseif(isset($_REQUEST['action']) && $_REQUEST['action'] == 'hide' && $_REQUEST['page'] == 'reviewSite-top-rating') :
		
			global $wpdb;
			
			$query	= "UPDATE `".$wpdb->prefix.$this->table."` ".
					  "SET hide = '".$_REQUEST['hide']."' ".
					  "WHERE id = '".$_REQUEST['ID']."' ";
					  
			$wpdb->query($query);
			
		endif;
	}
	
	// generate value from custom options
	function generateValue()
	{
		global $wpdb;

		$query	= "SELECT * FROM `".$wpdb->prefix.$this->table."` ".
				  "ORDER BY id ASC";
				  
		$this->ratings	= $wpdb->get_results($query,ARRAY_A);
	}
	
	// updateData
	function updateData()
	{
		global $wpdb;
		
		$query	= "UPDATE `".$wpdb->prefix.$this->table."` ".
				  "SET ".
				  	"name = '".$this->data['name']."', ".
					"rating = '".$this->data['rating']."', ".
					"visit_link = '".$this->data['visit_link']."', ".
					"review_link = '".$this->data['review_link']."' ,".
					"hide = '".$this->data['hide']."' ".
				  "WHERE id = '".$this->data['ID']."' ";
					
		$wpdb->query($query);
		
		$this->status	= "update";
	}
	
	// get Data
	function getData($id)
	{
		global $wpdb;
		
		$query	= "SELECT * FROM `".$wpdb->prefix.$this->table."` ".
				  "WHERE id = '".$id."' ";
				  
		$this->data	= $wpdb->get_row($query,ARRAY_A);
	}
	
	/*==================================================================================*/
	/*=========================				VIEW			   =========================*/
	/*==================================================================================*/
	
	// notification
	function notification()
	{
		$this->processingInput();
		$this->generateValue();
		
		if($this->status == "update") :
		?><div class="message updated fade"><p>The data have been updated</p></div><?php
		endif;
	}
	
	function table()
	{
		?>
        <table class="widefat" style="width:90%;">
        	<thead>
            <tr>
            	<th width="1%">No</th>
                <th>Name</th>
                <th width="20%">Rating</th>
                <th width="10%">Site</th>
                <th width="10%">Review</th>
                <th width="10%">Hide</th>
                <th width="10%">Edit</th>
            </tr>
            </thead>
		<?php
		$i	= 1;
		
		foreach($this->ratings as $rating) :
			?>
            <tr>
            	<td style="text-align:center"><?php echo $i; ?></td>
                <td><?php echo $rating['name']; ?></td>
                <td>
					<?php 
                        if(!empty($rating['rating']) && is_numeric($rating['rating'])) : 
                            for($j = 1;$j <= $rating['rating'];$j++) :
                            ?><img src="<?php bloginfo('template_url'); ?>/images/icon-star.png" alt="" /><?php
                            endfor;
                        else :
                            ?>&nbsp;<?php
                        endif;
                    ?>
                </td>
                <td style="text-align:center">
                	<?php if(!empty($rating['visit_link'])) : ?>
                    <a href="<?php echo $rating['visit_link']; ?>" title="">visit site</a>
                    <?php else : ?>
                    &nbsp;
                    <?php endif; ?>
                </td>
                <td style="text-align:center">
                	<?php if(!empty($rating['review_link'])) : ?>
                    <a href="<?php echo $rating['review_link']; ?>" title="">view review</a>
                    <?php else : ?>
                    &nbsp;
                    <?php endif; ?>
                </td>
                <td style="text-align:center">
					<?php
					$link	= get_bloginfo('url')."/wp-admin/admin.php?page=reviewSite-top-rating&amp;ID=".$rating['id']."&amp;action=hide";
					
					if($rating['hide'] == 'true') :
						$link	= $link."&amp;hide=false";
						$link	= wp_nonce_url($link);
						?><a href="<?php echo $link; ?>" title="">Yes</a><?php
					else :
						$link	= $link."&amp;hide=true";
						$link	= wp_nonce_url($link);
						?><a href="<?php echo $link; ?>" title="">No</a><?php
					endif;
					?>
                </td>
                <td style="text-align:center">
					<?php $link	= get_bloginfo('url')."/wp-admin/admin.php?page=reviewSite-top-rating&amp;ID=".$rating['id']."&amp;action=edit"; ?>
                    <a href="<?php echo $link; ?>" title="">Edit</a>
                </td>                
            </tr>
            <?php
			$i++;
		endforeach;
		?>
        	<tfoot>
            <tr>
            	<th width="1%">No</th>
                <th>Name</th>
                <th width="20%">Rating</th>
                <th width="5%">Site</th>
                <th width="5%">Review</th>
                <th width="5%">Hide</th>
                <th width="5%">Edit</th>
            </tr>
            </tfoot>
        </table>
        <?php
	}
	
	function form()
	{
		if($this->edit) :
		?>
        <form method="post" action="">
		<div id="header-reviewSite" class="metabox-holder ReviewSite-body"  style="margin-top:20px;width:90% !important;">
			<div class="postbox">
               	<h3>Edit Rating</h3>
                   
				<div class="inside">
					<div class="input-row">
						<label>Name</label>
						<div class="input-field"><input type="text" name="rating[name]" value="<?php echo $this->data['name']; ?>" /></div>
						<div class="wrapper"></div>
					</div>
                    
					<div class="input-row">
						<label>Rating</label>
						<div class="input-field">
                        	<select name="rating[rating]">
                           	<?php foreach($this->rating_option as $key => $value) : ?>
                            	<option value="<?php echo $key; ?>" <?php if($this->data['rating'] == $key) { ?>selected='selected' <?php } ?>>
									<?php echo $value; ?>
                                </option>
                            <?php endforeach; ?>
                            </select>
                        </div>
						<div class="wrapper"></div>
					</div>
                    
					<div class="input-row">
						<label>Site Link</label>
						<div class="input-field"><input type="text" name="rating[visit_link]" value="<?php echo $this->data['visit_link']; ?>" /></div>
						<div class="wrapper"></div>
					</div>
                    
					<div class="input-row">
						<label>Review Link</label>
						<div class="input-field"><input type="text" name="rating[review_link]" value="<?php echo $this->data['review_link']; ?>" /></div>
						<div class="wrapper"></div>
					</div>
                    
					<div class="input-row">
						<label>Hide</label>
						<div class="input-field">
                        	<select name="rating[hide]">
                           	<?php foreach($this->hide as $key => $value) : ?>
                            	<option value="<?php echo $key; ?>" <?php if($this->data['hide'] == $key) { ?>selected='selected' <?php } ?>>
									<?php echo $value; ?>
                                </option>
                            <?php endforeach; ?>
                            </select>
                        </div>
						<div class="wrapper"></div>
					</div>
                    
                    <div class="input-button" style="clear:both;">
                    	<input type="hidden" name="rating[ID]" value="<?php echo $this->data['id']; ?>" />
                        <?php wp_nonce_field('reviewSite-update-top-rating'); ?>
                        <input type="submit" class="button-primary" name="savethis" value="<?php _e('Update', 'ReviewSite') ?>" />
                    </div>
				</div>                                   
			</div>
            
		</div>
        </form>
		<?php
		endif;
	}
	
	function view()
	{
		$this->notification();
		
		?>
        <div id="reviewSite-body" class="wrap">
        	<h2>ReviewSite Top Rating</h2>
            
            <?php $this->table(); ?>
            <?php $this->form(); ?>
        </div>
        <?php
	}
	
	function front()
	{
		global $wpdb;
		
		$query		= "SELECT * FROM `".$wpdb->prefix.$this->table."` ".
					  "WHERE hide = 'false' ".
					  "ORDER BY id ASC ";
				  
		$ratings	= $wpdb->get_results($query,ARRAY_A);
		
		if(sizeof($ratings) > 0) :
		?>
            <table cellpadding="5" width="100%">
            	<thead>
                <tr>
                	<th width="15%">Rank</th>
                    <th width="30%">Name</th>
                    <th>Rating</th>
                    <th width="20%">Details</th>
				</tr>
                </thead>
                <tbody>
        <?php
		
		$i	= 1;
		foreach($ratings as $rating) :
		?>
                <tr>
                	<td class="number"><?php echo $i; ?></td>
                    <td class="text"><?php echo $rating['name']; ?></td>
                    <td class="image">
                    <?php for($j = 1; $j <= $rating['rating']; $j++): ?>
                    	<img src="<?php bloginfo('template_url'); ?>/images/icon-star-mini.png" alt="" />
                    <?php endfor; ?>
                    </td>
                    <td class="link">
                    <?php 
					if(!empty($rating['visit_link'])) :
						
						
						
						if(function_exists('linkcloaker_only_link')) :
							linkcloaker_only_link($rating['visit_link'],'Visit Site'); echo("<br />");
						else :
							?><a href="<?php echo $rating['visit_link']; ?>" title="Visit Site">Visit Site</a><br /><?php
                        endif;
                    endif;
					?>

                    <?php if(!empty($rating['review_link'])) : ?>
                    	<a href="<?php echo $rating['review_link']; ?>" title="View Review">Detail</a>
                    <?php endif; ?>

                    </td>
                </tr>

        <?php
			$i++;
		endforeach;
		endif;
		
		?>
                </tbody>
            </table>
        <?php
	}
}

$reviewsite_toprating	= new ReviewSiteTopRating;
$reviewsite_toprating->init();

?>